define([
    'backbone',
    'Layout',
    'modules/appointments/requested/requested-appointment-view',
    'modules/appointments/requested/requested-appointments-collection',
], function(
    Backbone,
    Layout,
    RequestedAppointmentView,
    RequestedAppointmentsCollection
) {
    'use strict';

    describe('Requested Appointment View', function() {
        var view;
        var $view;
        var model;
        var messageModel;
        var linkModel;
        var layout = new Layout();

        layout.render();

        beforeEach(function() {
            // eslint-disable-next-line new-cap
            messageModel = new Backbone.Model({
                'rel': 'self',
                'href': '/var/VeteranAppointmentRequestService/v4/rest/appointment-service/patient/ICN/1006088937/appointments/system/var/id/2c92809f6549bc4b016549d76ab60008',
                'objectType': 'AtomLink',
                'title': 'self',
            });
            linkModel = new Backbone.Model({
                'appointment-request-messages': messageModel,
            });
            
            // eslint-disable-next-line new-cap
            model = new RequestedAppointmentsCollection.prototype.model({
                'patientIdentifier': {
                    'uniqueId': '1006088937',
                    'assigningAuthority': 'ICN',
                },
                'lastUpdatedDate': '08/17/2018 17:42:58',
                'facility': {
                    'name': 'BOSTON HCS VAMC',
                    'type': 'VAMC',
                    'facilityCode': '523',
                    'state': 'MA',
                    'city': 'BOSTON',
                    'address': '150 SOUTH HUNTINGTON AVENUE',
                    'parentSiteCode': '523',
                    'objectType': 'Facility',
                    'link': [],
                },
                'links': linkModel,
            });

            view = new RequestedAppointmentView({model: model});

            layout.showChildView('content', view);
            $view = view.$el;
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });
        
        it('has a feedback link', function () {
            expect($view.find('#appointment-feedback-link > a:first-child').attr('href')).toBe('#feedback');
            expect($view.find('#appointment-feedback-link > a:first-child').text()).toEqual('Provide feedback on this submission.');
        });
    });
});
